# 画面設計書 49-kubeadm config

## 概要

本ドキュメントは、kubeadmのconfigコマンドの画面設計書である。kubeadmの設定管理（デフォルト設定の表示、設定ファイルの移行・検証、イメージ管理）を行うCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：kubeadmはkube-system名前空間のkubeadm-config ConfigMapに内部設定を保存する。configコマンドは、設定のデフォルト値確認、古いAPIバージョンからの移行、設定ファイルの検証、コントロールプレーンイメージの一覧表示・プルを提供し、クラスタの構築・アップグレード作業を支援する。

**画面へのアクセス方法**：ターミナルから `kubeadm config SUBCOMMAND [flags]` を実行する。

**主要な操作・処理内容**：
1. `kubeadm config print init-defaults` - init設定のデフォルト値を表示
2. `kubeadm config print join-defaults` - join設定のデフォルト値を表示
3. `kubeadm config print reset-defaults` - reset設定のデフォルト値を表示
4. `kubeadm config print upgrade-defaults` - upgrade設定のデフォルト値を表示
5. `kubeadm config migrate` - 古いAPIバージョンの設定を最新バージョンに変換
6. `kubeadm config validate` - 設定ファイルのバリデーション
7. `kubeadm config images list` - 使用するコンテナイメージ一覧を表示
8. `kubeadm config images pull` - コンテナイメージをプル

**画面遷移**：config print で確認した設定は kubeadm init/join の --config フラグで使用される。

**権限による表示制御**：print/migrate/validateはローカル処理。images pullはCRIソケットへのアクセスが必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 補助機能 | kubeadm設定の管理（initで使用する設定の確認・変換） |

## 画面種別

設定管理（CLIサブコマンド構造）

## URL/ルーティング

```
kubeadm config print (init-defaults|join-defaults|reset-defaults|upgrade-defaults) [flags]
kubeadm config migrate --old-config <path> [--new-config <path>] [flags]
kubeadm config validate --config <path> [flags]
kubeadm config images list [flags]
kubeadm config images pull [flags]
```

## 入出力項目

### 入力項目（print サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --component-configs | []string | 任意 | [] | 表示するコンポーネント設定（init-defaultsのみ。KubeletConfiguration, KubeProxyConfiguration） |

### 入力項目（migrate サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --old-config | string | 必須 | "" | 移行元の設定ファイルパス |
| --new-config | string | 任意 | "" | 移行先のファイルパス（未指定時はstdout） |
| --allow-experimental | bool | 任意 | false | 実験的APIへの移行を許可 |

### 入力項目（validate サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --config | string | 必須 | "" | 検証する設定ファイルパス |
| --allow-deprecated | bool | 任意 | false | 非推奨APIの検証を許可 |
| --allow-experimental | bool | 任意 | false | 実験的APIの検証を許可 |

### 入力項目（images list/pull 共通）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --kubernetes-version | string | 任意 | 自動取得 | Kubernetesバージョン |
| --feature-gates | string | 任意 | "" | Feature Gate設定 |
| --image-repository | string | 任意 | registry.k8s.io | イメージリポジトリ |
| --config | string | 任意 | "" | 設定ファイルパス |

### 入力項目（images pull 追加）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --cri-socket | string | 任意 | 自動検出 | CRIソケットパス |

### 出力項目

| サブコマンド | 出力内容 |
|-------------|---------|
| print | YAML形式のデフォルト設定 |
| migrate | YAML形式の移行後設定 |
| validate | "ok" または エラーメッセージ |
| images list | イメージ名一覧 |
| images pull | プル進捗メッセージ |

## 表示項目

print init-defaults出力例：
```yaml
apiVersion: kubeadm.k8s.io/v1beta4
kind: InitConfiguration
localAPIEndpoint:
  advertiseAddress: 1.2.3.4
  bindPort: 6443
...
---
apiVersion: kubeadm.k8s.io/v1beta4
kind: ClusterConfiguration
kubernetesVersion: v1.x.x
...
```

images list出力例：
```
registry.k8s.io/kube-apiserver:v1.x.x
registry.k8s.io/kube-controller-manager:v1.x.x
registry.k8s.io/kube-scheduler:v1.x.x
registry.k8s.io/kube-proxy:v1.x.x
registry.k8s.io/coredns/coredns:v1.x.x
registry.k8s.io/pause:3.x
registry.k8s.io/etcd:3.x.x-0
```

## イベント仕様

### 1-print実行

1. `getDefaultInitConfigBytes()` / `getDefaultNodeConfigBytes()` 等で内部設定を生成
2. `configutil.MarshalKubeadmConfigObject()` でYAMLシリアライズ
3. `--component-configs` 指定時は追加のコンポーネント設定も出力
4. 複数ドキュメントは `---` 区切りで結合

### 2-migrate実行

1. `--old-config` ファイルを読み込み
2. `configutil.MigrateOldConfig()` で最新バージョンに変換
3. 結果を `--new-config` ファイルまたはstdoutに出力

### 3-validate実行

1. `--config` ファイルを読み込み
2. `configutil.ValidateConfig()` でバリデーション実行
3. 成功時は "ok" を出力、失敗時はエラーを返す

### 4-images list/pull実行

1. 設定からイメージリポジトリとKubernetesバージョンを取得
2. `images.GetControlPlaneImages()` でイメージ一覧を生成
3. list: プリンター経由で出力
4. pull: `containerRuntime.PullImage()` で各イメージをプル

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| print | なし | なし | ローカル処理のみ |
| migrate | ファイルシステム（--new-config指定時） | WRITE | 変換後設定ファイルの出力 |
| validate | なし | なし | ローカル処理のみ |
| images list | なし | SELECT | イメージ一覧の生成（APIアクセスなし） |
| images pull | コンテナランタイム | UPDATE | コンテナイメージのプル |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| INFO-01 | 情報 | `ok` | validate成功時 |
| INFO-02 | 情報 | `[config/images] Pulled %s` | images pull成功時 |
| ERR-01 | エラー | `the --old-config flag is mandatory` | migrate時に--old-config未指定 |
| ERR-02 | エラー | `the --config flag is mandatory` | validate時に--config未指定 |
| ERR-03 | エラー | `--component-configs needs to contain some of %v` | 不正なコンポーネント設定名 |
| ERR-04 | エラー | `failed to pull image %q` | イメージプル失敗時 |

## 例外処理

- 設定ファイルが存在しない場合はファイルシステムエラー
- バリデーションエラーは非ゼロ終了コードで報告
- 未知のAPIフィールドはアンマーシャルエラーとして報告
- CRIソケットへの接続失敗時（images pull）はエラー

## 備考

- サポートするAPIバージョンはv1beta4
- legacyKindToGroupMapでKubeletConfiguration/KubeProxyConfigurationの旧Kind名をグループ名に変換
- print系コマンドのプレースホルダトークン（configutil.PlaceholderToken）はバリデーション通過用
- --kubeconfig永続フラグがあるがconfig系コマンドでは実質未使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.go | `cmd/kubeadm/app/cmd/config.go` | ImagesList構造体（行472-474）とlegacyKindToGroupMap（行176-179）を理解する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | config.go | `cmd/kubeadm/app/cmd/config.go` | newCmdConfig関数（行53-76）で4つのサブコマンド（print, migrate, validate, images）を登録 |

**主要処理フロー**:
1. **行71**: print サブコマンド追加
2. **行72**: migrate サブコマンド追加
3. **行73**: validate サブコマンド追加
4. **行74**: images サブコマンド追加

#### Step 3: 各サブコマンドの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.go | `cmd/kubeadm/app/cmd/config.go` | newCmdConfigPrint（行79-93）でprint系サブコマンドを定義。runConfigPrintActionDefaults（行142-159）がデフォルト設定を出力 |
| 3-2 | config.go | `cmd/kubeadm/app/cmd/config.go` | newCmdConfigMigrate（行258-309）で設定移行処理。MigrateOldConfig呼び出しに注目 |
| 3-3 | config.go | `cmd/kubeadm/app/cmd/config.go` | newCmdConfigValidate（行312-352）でバリデーション処理 |
| 3-4 | config.go | `cmd/kubeadm/app/cmd/config.go` | newCmdConfigImages（行355-364）でimagesサブコマンドを定義。list/pullの2つ |

### プログラム呼び出し階層図

```
newCmdConfig (config.go:53)
    |
    +-- newCmdConfigPrint (config.go:79)
    |       +-- print init-defaults → getDefaultInitConfigBytes()
    |       +-- print join-defaults → getDefaultNodeConfigBytes()
    |       +-- print reset-defaults → getDefaultResetConfigBytes()
    |       +-- print upgrade-defaults → getDefaultUpgradeConfigBytes()
    |
    +-- newCmdConfigMigrate (config.go:258)
    |       +-- configutil.MigrateOldConfig()
    |
    +-- newCmdConfigValidate (config.go:312)
    |       +-- configutil.ValidateConfig()
    |
    +-- newCmdConfigImages (config.go:355)
            +-- images list → ImagesList.Run()
            |       +-- images.GetControlPlaneImages()
            +-- images pull → PullControlPlaneImages()
                    +-- containerRuntime.PullImage()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

print:
  (なし) ──────────> DefaultedStaticInitConfiguration() ──> stdout (YAML)

migrate:
  old-config ──────> MigrateOldConfig() ──────────────> new-config / stdout

validate:
  config ──────────> ValidateConfig() ────────────────> "ok" / error

images list:
  flags ───────────> GetControlPlaneImages() ─────────> stdout (イメージ名)

images pull:
  flags ───────────> GetControlPlaneImages()
                     containerRuntime.PullImage() ────> stdout (プル結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.go | `cmd/kubeadm/app/cmd/config.go` | ソース | configコマンド本体の実装 |
| config/ | `cmd/kubeadm/app/util/config/` | ソース | 設定ロード・変換・検証ユーティリティ |
| images/ | `cmd/kubeadm/app/images/` | ソース | イメージ名生成ユーティリティ |
| componentconfigs/ | `cmd/kubeadm/app/componentconfigs/` | ソース | コンポーネント設定管理 |
| runtime/ | `cmd/kubeadm/app/util/runtime/` | ソース | コンテナランタイムユーティリティ |
